#if defined SHADERS_VERTEX
    out vec2 vertex_coord;
    out vec2 vertex_midcoord;
    out vec2 vertex_pom;
    out vec2 vertex_lightmap;
    out vec3 vertex_normal;
    out vec3 view_position;
    out vec4 vertex_color;

    flat out float vertex_material;

    out vec3 position0;
    out vec3 position1;
    out vec3 position2;

    out mat3 tbn;

    #if defined GBUFFERS_HAND
        mat4 projection = gl_ProjectionMatrix;
    #else
        mat4 projection = gbufferProjection;
    #endif

    #include "/program/shaders0/common/animation.glsl"
    
    vec3 curvature(vec3 position){
        atmosphere_constant ac = atmosphere_s();

        position.yx *= rotation(position.x / ac.planet_radius);
        position.yz *= rotation(position.z / ac.planet_radius);

        return position;
    }

    void main(){
        vertex_material = layout_material.x;
        vertex_coord = layout_texcoord.xy;
        vertex_midcoord = layout_midcoord.xy;
        vertex_pom = abs(vertex_coord - vertex_midcoord) * 2.0;
        vertex_lightmap = layout_lightmap.xy / 255.0;
        vertex_normal = mat3(gbufferModelViewInverse) * (gl_NormalMatrix * layout_normal.xyz);
        vertex_color = layout_color;

        tbn[0] = mat3(gbufferModelViewInverse) * (gl_NormalMatrix * (layout_tangent.xyz / layout_tangent.w));
        tbn[2] = vertex_normal;
        tbn[1] = cross(tbn[0], tbn[2]);

        vec2 resolution = textureSize2D(tex, 0);
        mat3 tbn_space = mat3(tbn[0] * resolution.y / resolution.x, tbn[1], tbn[2]);

        position0 = trans_mad(gl_ModelViewMatrix, layout_position.xyz);
        position1 = animation(curvature(trans_mad(gbufferModelViewInverse, position0)));
        position2 = position1 + cameraPosition;

        view_position = (position0 * gl_NormalMatrix) * tbn_space;

        position0 = trans_mad(gbufferModelView, position1);

        #if defined GBUFFERS_HAND
            #ifdef WAVING_HAND
                position0.y += sin(frameTimeCounter) * 0.03;
                position0.z -= cos(frameTimeCounter) * 0.003;
            #endif
        #endif

        gl_Position = position0.xyzz * diagonal4(projection) + gbufferProjection[3];
        gl_Position.xy += jitter * gl_Position.w;
    }
#elif defined SHADERS_FRAGMENT
    in vec2 vertex_coord;
    in vec2 vertex_midcoord;
    in vec2 vertex_pom;
    in vec2 vertex_lightmap;
    in vec3 vertex_normal;
    in vec3 view_position;
    in vec4 vertex_color;

    flat in float vertex_material;

    in vec3 position0;
    in vec3 position1;
    in vec3 position2;

    in mat3 tbn;

    /* RENDERTARGETS:9 */
    layout (location = 0) out uvec4 buffers0;
    
    #include "/program/shaders0/common/material.glsl"
    #include "/program/shaders0/common/parallax.glsl"
    #include "/program/shaders0/common/water_normal.glsl"

    void main(){
        float id = 1.0;
        materials(id, vertex_material);

        bool water = id == 2;

        vec2 offset = vertex_coord * texel + sin(frame_16);
        float noise = rand(offset) / 255.0;

        float blocklight = saturate(vertex_lightmap.x + noise);
        float skylight = saturate(vertex_lightmap.y + noise);

        #if defined GBUFFERS_TERRAIN			
			vec3 ray_position = vec3(vertex_coord, 0.0);

            mat2 tex_grad = mat2(dFdx(vertex_coord), dFdy(vertex_coord));
            vec2 coord = parallax_occlusion_mapping(vertex_coord, vertex_midcoord, position0, view_position, tbn, tex_grad, ray_position);

            vec4 atlas0 = texture_grad(tex, coord, tex_grad[0], tex_grad[1]) * vertex_color;
            vec4 atlas1 = texture_grad(normals, coord, tex_grad[0], tex_grad[1]);
            vec4 atlas2 = texture_grad(specular, coord, tex_grad[0], tex_grad[1]);
			
			#ifdef PARALLAX
				vec3 pos0 = position2 + ray_position;
				vec3 view_space = trans_mad(gbufferModelView, pos0 - cameraPosition);
				vec3 screen_space = proj_mad(gbufferProjection, view_space) / -view_space.z * 0.5 + 0.5;
				
				//gl_FragDepth = screen_space.z;
			#endif
        #else
            vec4 atlas0 = texture2(tex, vertex_coord) * vertex_color;
            vec4 atlas1 = texture2(normals, vertex_coord);
            vec4 atlas2 = texture2(specular, vertex_coord);
        #endif

        #if !defined GBUFFERS_BASIC
            if(atlas0.w < 0.128) discard;
        #endif

        #if defined GBUFFERS_TRANSLUCENT
            if(!gl_FrontFacing) discard; 
        #endif

        #if defined GBUFFERS_ENTITY
            atlas0.xyz = mix(atlas0.xyz, entityColor.xyz, entityColor.w);
        #endif

        #ifndef ALPHA_TEXTURES
            #if defined GBUFFERS_TERRAIN
                atlas0.xyz = vertex_color.xyz;
            #endif
        #endif

        #if defined GBUFFERS_TEXTURED
            atlas0.w = 1.0;
        #endif

        vec3 normal;

        #if defined GBUFFERS_TERRAIN
            #ifdef MC_NORMAL_MAP
                normal.xy = atlas1.xy * 2.0 - (254.0 / 255.0);
                normal.z = sqrt(1.0 - dot(normal.xy, normal.xy));
                normal = tbn * normal;
            #else
                normal = vertex_normal;
            #endif
        #else       
            normal = vertex_normal;
        #endif  

        #if defined GBUFFERS_TRANSLUCENT
            if(water){
                atlas0 = vec4(0.0);
                normal = tbn * water_normal(position1, position2);
            }
        #endif

        buffers0.x = packUnorm4x8(atlas0);
        buffers0.y = packUnorm4x8(atlas2);
        buffers0.z = packSnorm4x8(vec4(encode_unit_vector(normal), 0.0, 0.0));
        buffers0.w = packUnorm4x8(vec4(id / 255.0, blocklight, skylight, 1.0));
    }
#endif